const { src, dest, parallel, watch, series, gulp, registry } = require('gulp'),
    log = require('fancy-log'),
    s3 = require('vinyl-s3'),
    s3upload = require('gulp-s3-upload')(config),
    merge = require('gulp-merge-json'),
    glob = require("glob"),
    paths = require("./paths.js")
    ;


/*
*Add your Amazon credentials here
*/
var config = {
    accessKeyId: "",
    secretAccessKey: ""
}


/**
 * upload data to s3
 */
function UploadData() {
    return src('src/data/final/src/*.json')
        .pipe(s3upload({
            Bucket: paths.paths.bucket, //  Required
            ACL: 'public-read'       //  Needs to be user-defined
        }, {
            // S3 Constructor Options, ie:
            maxRetries: 5
        }))
        ;
}

/**
 * Download data from S3
 */
function downloadData() {
    return s3.src((paths.paths.s3bucket + '*.json'), { buffer: false })
        .pipe(dest('build/data/NEW'));
}

/**
 * concat json
 */
function concatJson(done) {
    var files = glob.sync('src/*.html');
    let count = 0;
    files.map(function (file) {
        return src(['src/data/global.json', 'src/data/components.json', 'src/tag/*/*.json', 'src/components/*/*.json'])
            .pipe(merge({
                fileName: (file + '.json'),
                concatArrays: false
            }))
            .pipe(dest('src/data/final'))
            .on('end', function () {
                count++;
                log('file name: ' + file, files);
                if (files.length === count) return done();
            })
    }
    )
}


exports.downloadData = downloadData;
exports.UploadData = UploadData;
exports.concatJson = concatJson;
