// is this a development build?
const devBuild = ((process.env.NODE_ENV || 'development').trim().toLowerCase() === 'development');

const { src, dest, parallel, watch, series, gulp, registry } = require('gulp'),
  paths = require("./paths.js"),
  { scripts, remotescripts,moveScripts } = require("./scripts.js"),
  { html, css, fonts } = require("./ui.js"),
  { UploadData, downloadData, concatJson } = require("./data.js")
  ;


exports.html = html;
exports.remotescripts = remotescripts;
exports.scripts = scripts;
exports.moveScripts = moveScripts;
exports.downloadData = downloadData;
exports.default = series(
  // concatJson,
  // UploadData,
  // downloadData,
  // remotescripts,
  html,
  parallel(css, scripts, fonts, moveScripts)
);


if (devBuild) {
  // watch(['src/components/*/*.json', "src/data/*.json"], concatJson);
  watch(['build/data/nutra-complete-product-test/*.json'], html);
  watch(['src/**/**/*.scss'], css);
  watch(['src/components/**/scripts.js'], moveScripts);
  watch(['src/**/**/*.html'], html);
  watch(['src/**/*.html'], html);
  watch(['src/*/*.html'], html);
  watch(['src/*.html'], html);
  watch(['src/js/*.js'], scripts);
}
