const { src, dest, parallel, watch, series, gulp, registry } = require('gulp'),
  concat = require('gulp-concat-util'),
  uglify = require('gulp-uglify-es').default,
  rename = require('gulp-rename'),
  sourcemaps = require('gulp-sourcemaps'),
  babel = require('gulp-babel'),
  order = require("gulp-order"),
  remoteSrc = require('gulp-remote-src')
  ;

/**
 * remote JS
 */
function remotescripts() {

  return  remoteSrc(['app.min.js'], {
    base: 'https://lp.ultimatedognutrition.com/product-v02/js/'
    })
    .pipe(rename('remote.min.js' ))
    .pipe(dest('build/js'))
}

function moveScripts() {
  return src(['src/components/*/scripts.js'])
  .pipe(sourcemaps.init())
    .pipe(babel({
      presets: ['@babel/env']
    }))
  .pipe(concat('app.js'))  
  .pipe(concat.header('$(document).ready(function () {'))
  .pipe(concat.footer('\n});\n'))
  .pipe(rename({ extname: '.min.js' }))
  .pipe(uglify(/* options */))
  .pipe(sourcemaps.write('.'))
  .pipe(dest('build/scripts'))
}

/**
 * JS
 */
function scripts() {
  return src(['src/js/dependencies/bootstrap.min.js', 'src/js/dependencies/lazysizes.min.js', 'src/js/dependencies/slick.min.js'])
    .pipe(sourcemaps.init())
    .pipe(babel({
      presets: ['@babel/env']
    }))
    .pipe(order([
      "js/dependencies/*.js"
    ]))
    .pipe(concat('dependencies.js'))
    .pipe(rename({ extname: '.min.js' }))
    .pipe(uglify(/* options */))
    .pipe(sourcemaps.write('.'))
    .pipe(dest('build/js'))
}

exports.moveScripts = moveScripts;
exports.scripts = scripts;
exports.remotescripts = remotescripts;
