//-------------------Shooping Cart------------------------------//
const disclaimerBox = $('#disclaimerBox'),
disclaimerTrigger = $('#disclaimerTrigger'),
subscribeMode = $('#subscribeMode');

//- Select Subscribe option if click on disclaimer box title
disclaimerTrigger.on("click", function () {
let checkbox = $('#subscribeCheckbox');
let cartBtn = $('#cartCta');

checkbox.toggleClass('checked');
cartBtn.toggleClass('disabled');
})

function agreeToSS(status) {
let checkbox = $('#subscribeCheckbox');
let cartBtn = $('#cartCta');
if (status) {
    checkbox.addClass('checked');
    cartBtn.removeClass('disabled');
} else {
    checkbox.removeClass('checked');
    cartBtn.addClass('disabled');
}
}

// close disclaimer box
$('#closeDisclaimer').on('click', function () {
disclaimerBox.removeClass('subscribe-box__disclaimer--open');
});

// activate subscribe prices
$('.subscribe-box__default').on('click', function () {
let thisBtn = $(this);
let cartBtn = $('#cartCta');
let checkbox = $('#subscribeCheckbox');

$('.subscribe-box__default').removeClass('active');
thisBtn.addClass('active');

disclaimerBox.addClass('subscribe-box__disclaimer--open');

//- reset all UIs
if (cartBtn.hasClass('disabled')) {
    cartBtn.removeClass('disabled');
}

if (checkbox.hasClass('checked')) {
    checkbox.removeClass('checked');
}

if (thisBtn.hasClass('subscribe')) {
    subscribeMode.attr('data-subscribe', 'true');

    if (!cartBtn.hasClass('disabled')) {
        cartBtn.addClass('disabled');
    }

    if (!disclaimerBox.hasClass('subscribe-box__disclaimer--open')) {
        disclaimerBox.addClass('subscribe-box__disclaimer--open');
    }

} else {
    subscribeMode.attr('data-subscribe', 'false')

    if (disclaimerBox.hasClass('subscribe-box__disclaimer--open')) {
        disclaimerBox.removeClass('subscribe-box__disclaimer--open');
    }
}
$('.cart__product.active').trigger("click");
});

/**
* Subscribe Mode - checkbox mode
*/
$('.purchaseMode__input').on('click', function (check) {
// console.log($(this).is(":checked"));

let checkboxType;

if (subscribeMode.attr('data-subscribe') === 'false') {
    // $('#orderNow').attr('data-subscribe', 'true');
    subscribeMode.attr('data-subscribe', 'true');
    checkboxType = true;
    disclaimerBox.addClass('subscribe-box__disclaimer--open');

} else {
    // $('#orderNow').attr('data-subscribe', 'false')
    subscribeMode.attr('data-subscribe', 'false');
    checkboxType = false;

    // on touch screens
    if (disclaimerBox.hasClass('subscribe-box__disclaimer--open')) {
        disclaimerBox.removeClass('subscribe-box__disclaimer--open');
    }
}

this.setAttribute('checked', checkboxType);

$('.cart__product.active').trigger("click");
});

//set prices   
function activeProduct() {
let thisProduct = $(this);
let subscribe = $('#subscribeMode').attr('data-subscribe');

let price, link, ship, alternativeContentValue, regularity;

if (subscribe === 'true') {
    price = 'data-subscribe-price';
    link = 'data-subscribe-link';
    ship = 'data-subscribe-shipping';
    regularity = '';

    if ($('#alternativeContent').length) {
        alternativeContentValue = '';
    }
} else {
    price = 'data-price';
    link = 'data-link';
    ship = 'data-shipping';
    regularity = '';

    if ($('#alternativeContent').length) {
        alternativeContentValue = $('#alternativeContent').attr('data-alt-content');
    }
}

$('.cart__product').removeClass('active');
thisProduct.addClass('active');

if (thisProduct.attr('data-units') === "6" && subscribe === 'subscribe') {
    $('.perJar .value').html(parseFloat(
        (thisProduct.attr(price)) / (thisProduct.attr('data-units')) + 0.01
    ).toFixed(2));
} else {
    $('.perJar .value').html(parseFloat(
        (thisProduct.attr(price)) / (thisProduct.attr('data-units'))
    ).toFixed(2));
}

$('.current .value').html(thisProduct.attr(price) + regularity);
$('.retailPrice .value').html(thisProduct.attr('data-retail'));
$('.shipping .value').html(thisProduct.attr(ship));
$('.cart__image div:not(.cart__imgsrc)').removeClass('show').addClass('hide');
$('.cart__image .' + thisProduct.attr('data-units') + "").removeClass('hide').addClass('show');

if ($('#alternativeContent').length) {
    $('#alternativeContent').html(' ' + alternativeContentValue);
}

let param = $('.cta').attr('data-param');
$('.cta').attr('href', thisProduct.attr(link) + param);
};

$('.cart__product').on('click', activeProduct);
$('.cart__product.active').trigger("click");
//------------------ End Shooping Cart-------------------------//


//-------------------Take to shooping cart----------------------//
if ($('#salesBanner').length) {
    let salesBannerHeight = Math.floor($('#salesBanner').height());

    if ($('#salesBanner').hasClass('isStick')) {
        $('#salesBanner, .btn:not(.cta)').on('click', function (event) {
            $('html, body').animate({
                scrollTop: $("#orderNow").offset().top - salesBannerHeight
            }, 1000);
        });
    } else {
        $('#salesBanner, .btn:not(.cta)').on('click', function (event) {
            $('html, body').animate({
                scrollTop: $("#orderNow").offset().top
            }, 1000);
        });
    }
} else {
    $('.btn:not(.cta)').on('click', function (event) {
        $('html, body').animate({
            scrollTop: $("#orderNow").offset().top
        }, 1000);

    });
}
//------------------ End Take to Shooping Cart------------------//
