// is this a development build?
const devBuild = ((process.env.NODE_ENV || 'development').trim().toLowerCase() === 'development');

const { src, dest, parallel, watch, series, gulp, registry } = require('gulp'),
  paths = require("./paths.js"),
  { scripts, moveScripts } = require("./scripts.js"),
  { html, css, fonts } = require("./ui.js"),
  { UploadData, downloadData, moveFile, concatJson } = require("./data.js")
  ;


exports.html = html;
exports.moveScripts = moveScripts;
exports.default = series(
  // concatJson,
  // UploadData,
  // downloadData,
  html,
  parallel(css, fonts, scripts, moveScripts)
);

if (devBuild) {
  watch(['src/components/*/*.json', "src/data/*.json"], concatJson);
  watch(['build/data/reActive-vsl-v01/*.json'], html);
  watch(['src/*.scss'], css);
  watch(['src/**/*.scss'], css);
  watch(['src/**/**/*.scss'], css);
  watch(['src/components/**/scripts.js'], moveScripts);
  watch(['src/**/**/*.html'], html);
  watch(['src/**/*.html'], html);
  watch(['src/*.html'], html);
}
