const { src, dest, parallel, watch, series, gulp, registry } = require('gulp'),
  sass =   require('gulp-sass')(require('sass')),
  minifyCSS = require('gulp-csso'),
  sassGlob = require('gulp-sass-glob');
  htmlmin = require('gulp-htmlmin'),
  rename = require('gulp-rename'),
  sourcemaps = require('gulp-sourcemaps'),
  removeHtmlComments = require('gulp-remove-html-comments'),
  log = require('fancy-log'),
  nunjucksRender = require('gulp-nunjucks-render'),
  data = require('gulp-data'),
  fs = require('fs'),
  path = require('path'),
  paths = require("./paths.js")
  ;

/**
 * compile html
 */
function html() {
  let manageEnvironment = function (environment) {
    environment.addGlobal('timestamp', new Date().getTime())
  }

  let defaults = {
    path: 'src/',
    envOptions: {
      autoescape: false
    },
    manageEnv: manageEnvironment
  };

  return src('src/*.html')
    .pipe(data(function (file) {
      return JSON.parse(fs.readFileSync(paths.paths.data + path.basename(file.path) + '.json'));
    }))
    .pipe(nunjucksRender(defaults))
    .pipe(removeHtmlComments())
    .pipe(htmlmin({ collapseWhitespace: true }))
    .pipe(dest('build'))
}

/**
 * CSS
 */
function css() {
  return src('src/scss/*.scss')
    .pipe(sourcemaps.init())
    .pipe(sassGlob())
    .pipe(sass())
    .pipe(minifyCSS())
    .pipe(sourcemaps.write())
    .pipe(rename({ extname: '.min.css' }))
    .pipe(dest('build/css'))
}

/**
 * Fonts
 */
function fonts() {
  return src(['src/scss/vendors/slick/fonts/*.*'])
    .pipe(dest('build/css/fonts'))
}

exports.css = css;
exports.html = html;
exports.fonts = fonts;