function addCookie() {
    if ($('#vslVideo').length && !$.cookie('biox4-NS')) {
        videojs('vslVideo').ready(function () {
            this.on('timeupdate', function () {
                if (this.currentTime() >= (60 * timePlaying) || this.currentTime() == this.duration()) {
                    
                    if(typeof loadIframe !== 'undefined' && loadIframe == true) {
                        $("#vslContent").addClass('hidden');
                        $("#ecomIframe").removeClass('iframe__hidden');
                    } else {
                        $("#vslCTA").removeClass('hidden').addClass('visible');
                    }
                }
            })
        })

        $.cookie("biox4-NS", 1, { expires: 7 });
    } else if ($('#vslVideo').length || $.cookie('biox4-NS')) {
        if(typeof loadIframe !== 'undefined' && loadIframe == true) {
            $("#vslContent").addClass('hidden');
            $("#ecomIframe").removeClass('iframe__hidden');
        } else {
            $("#vslCTA").removeClass('hidden').addClass('visible');
        }
    }
}

addCookie();

if(typeof isFullScreen !== 'undefined' && isFullScreen == true) {
  /**
   * Plays Video in Full Screen Mode and returns to normal when Paused
   */

  let isMobile = {
    iOS: function() {
      return navigator.userAgent.match(/iPhone|iPad|iPod/i);
    }
  }

  let player = videojs('vslVideo'),
      playButton = document.getElementsByClassName('vjs-big-play-centered')[0],
      playButtonDummy = document.getElementsByClassName('dummyButton')[0];

  if(!isMobile.iOS()) {
    // console.log('Android');

    playButtonDummy.addEventListener('click', function(e) {    
      $(".vjs-big-play-centered").trigger('click');
    }, false);

    function playPauseAndFullscreen(e) {  
      e.preventDefault();
    
      if(player.hasClass('vjs-paused')) {
        player.play();
        player.requestFullscreen();  
      }
  
      if(player.hasClass('vjs-playing')) {
        player.pause();
        player.exitFullscreen();
      }
    }
  
    if(player.hasClass('vjs-touch-enabled')) {
      // console.log('touch-enabled');
  
      playButton.addEventListener('touchstart', function(e) {
        playPauseAndFullscreen(e);
        // console.log('shoot touch')
      }, false);
    } 
    
    if (player.hasClass('vjs-workinghover')) {
      // console.log('workinghover');
  
      playButton.addEventListener('click', function(e) {
        playPauseAndFullscreen(e);
        // console.log('shoot click')
      }, false);
    }
  }

  // Use default iOS behaviour
  if(isMobile.iOS()) {
    // console.log('iOS');
    playButtonDummy.style.display = "none";
  }
}

//- Play full video if clicked play button on thumbnail video (appers only if we have videoThumbnail string passed to vslSection component)
$('#vslVideoThumb .vjs-big-play-button').on('click touchend', function () {
    const fullVideoUrl = $('#vslVideoThumb').data('full-video');
    $('#vslVideoThumb').attr('id', 'vslVideo');
    $('#vslVideo video').attr('src', fullVideoUrl);
    videojs('vslVideo').controls(true);
    videojs('vslVideo').play();
    videojs('vslVideo').muted(false);
    addCookie();
});

//- Different VSL on mobile and desktop
const mobileVideoID = $('video-js').attr('data-video-id-mobile');

const changeVslOnMobile = play => {
    if (typeof mobileVideoID !== 'undefined' && mobileVideoID != '') {
        let isMobileDevice = /Android|webOS|iPhone|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
        if (isMobileDevice) {
            const myPlayer = videojs.getPlayer('vslVideo')
            if (window.innerHeight > window.innerWidth) {
                myPlayer.catalog.getVideo(mobileVideoID, function (error, video) {
                    myPlayer.catalog.load(video);
                    play ? myPlayer.play() : null;
                });
            }
        }
    };
};

changeVslOnMobile();

// Full screen Inline video
if (typeof isFullScreenInline !== 'undefined' && isFullScreenInline == true) {
    const videoPlayer = videojs('vslVideo');
    videoPlayer.controls(false);

    let startScrollTop,
        endScrollTop;

    $(".video").on("touchstart", function () {
        startScrollTop = $(window).scrollTop();
    });

    $(".video").on('touchend', function () {
        endScrollTop = $(window).scrollTop();
    });

    $(".video").on('click touchend', function () {
        if (startScrollTop === endScrollTop) {
            window.scrollTo(0, 0);
            if ($('body').hasClass('fullScreenVsl')) {
                videoPlayer.pause();
                $('.vjs-big-play-button').show();
                $('body').removeClass('fullScreenVsl');
            } else {
                videoPlayer.play();
                $('.vjs-big-play-button').hide();
                $('body').addClass('fullScreenVsl');
            };
        }
    });

    $(".video").one('click touchend', function () {
        changeVslOnMobile(true);
    });
}